/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.List;
import net.adventurez.entity.SpellCastingEntity;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ShamanEntity
extends SpellCastingEntity {
    public ShamanEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createShamanAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 35.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetGoalShaman());
        this.f_21345_.m_25352_(2, (Goal)new NormalAttack((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.7, 0.9));
        this.f_21345_.m_25352_(4, (Goal)new SummonCompanionsGoal());
        this.f_21345_.m_25352_(5, (Goal)new ThunderboltSpellGoal());
        this.f_21345_.m_25352_(7, (Goal)new EffectSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f, 1.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Witch.class}));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Zombie.class}));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Skeleton.class}));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Spider.class}));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{CaveSpider.class}));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
    }

    public static boolean canSpawn(EntityType<ShamanEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return ShamanEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && world.m_45527_(pos) || spawnReason == MobSpawnType.SPAWNER;
    }

    public int m_5792_() {
        return 1;
    }

    protected SoundEvent m_7515_() {
        return SoundInit.SHAMAN_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.SHAMAN_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.SHAMAN_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.SHAMAN_WALK_EVENT, 0.5f, 1.0f);
    }

    @Override
    public SoundEvent getCastSpellSound() {
        return SoundEvents.f_11862_;
    }

    private boolean tooManyCompanions() {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(40.0), EntitySelector.f_20408_);
        if (!list.isEmpty()) {
            int spiders = 0;
            int othermobs = 0;
            for (int i = 0; i < list.size(); ++i) {
                LivingEntity entity = (LivingEntity)list.get(i);
                if (entity.m_6095_() == EntityType.f_20554_) {
                    ++spiders;
                } else if (entity.m_6095_() == EntityType.f_20501_ || entity.m_6095_() == EntityType.f_20524_ || entity.m_6095_() == EntityType.f_20479_) {
                    ++othermobs;
                }
                if (spiders < 2 && othermobs < 4) continue;
                return true;
            }
        }
        return false;
    }

    private class LookAtTargetGoalShaman
    extends SpellCastingEntity.LookAtTargetGoal {
        private LookAtTargetGoalShaman() {
            super(ShamanEntity.this);
        }

        @Override
        public void m_8037_() {
            if (ShamanEntity.this.m_5448_() != null) {
                ShamanEntity.this.m_21563_().m_24960_((Entity)ShamanEntity.this.m_5448_(), (float)ShamanEntity.this.m_8085_(), (float)ShamanEntity.this.m_8132_());
            }
        }
    }

    private class NormalAttack
    extends MeleeAttackGoal {
        private final ShamanEntity summonerEntity;

        public NormalAttack(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.summonerEntity = (ShamanEntity)mob;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.summonerEntity.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.summonerEntity.m_6779_(livingEntity) && this.summonerEntity.m_20280_((Entity)livingEntity) < 7.0 && super.m_8036_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.f_25540_.m_5448_();
            if (livingEntity == null || this.summonerEntity.m_20280_((Entity)livingEntity) > 5.0) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (!this.f_25540_.m_21444_(livingEntity.m_20183_())) {
                return false;
            }
            return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
        }

        public double m_6639_(LivingEntity entity) {
            return this.f_25540_.m_20205_() * 2.3f * this.f_25540_.m_20205_() * 2.3f + entity.m_20205_();
        }
    }

    private class SummonCompanionsGoal
    extends SpellCastingEntity.CastSpellGoal {
        private SummonCompanionsGoal() {
            super(ShamanEntity.this);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !ShamanEntity.this.tooManyCompanions();
        }

        @Override
        public int getSpellTicks() {
            return 140;
        }

        @Override
        public int startTimeDelay() {
            return 340;
        }

        @Override
        public void castSpell() {
            ServerLevel serverWorld = (ServerLevel)ShamanEntity.this.m_9236_();
            int spellCount = 0;
            for (int i = 0; i < 20; ++i) {
                BlockPos blockPos = ShamanEntity.this.m_20183_().m_7918_(-3 + ShamanEntity.this.m_217043_().m_188503_(6), ShamanEntity.this.m_217043_().m_188503_(3), -3 + ShamanEntity.this.m_217043_().m_188503_(6));
                if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)ShamanEntity.this.m_9236_(), (BlockPos)blockPos, (EntityType)EntityType.f_20501_)) {
                    ++spellCount;
                    if (ShamanEntity.this.m_217043_().m_188501_() < 0.6f) {
                        CaveSpider caveSpiderEntity = (CaveSpider)EntityType.f_20554_.m_20615_((Level)serverWorld);
                        caveSpiderEntity.m_20035_(blockPos, ShamanEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                        caveSpiderEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                        serverWorld.m_47205_((Entity)caveSpiderEntity);
                    } else {
                        int randomInt = ShamanEntity.this.m_217043_().m_188503_(3);
                        Mob mobEntity = randomInt == 0 ? (Mob)EntityType.f_20501_.m_20615_((Level)serverWorld) : (randomInt == 1 ? (Mob)EntityType.f_20524_.m_20615_((Level)serverWorld) : (Mob)EntityType.f_20479_.m_20615_((Level)serverWorld));
                        mobEntity.m_20035_(blockPos, ShamanEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                        mobEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                        serverWorld.m_47205_((Entity)mobEntity);
                    }
                }
                if (spellCount >= 3) break;
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.SUMMON_PUPPET;
        }
    }

    private class ThunderboltSpellGoal
    extends SpellCastingEntity.CastSpellGoal {
        private ThunderboltSpellGoal() {
            super(ShamanEntity.this);
        }

        @Override
        protected int getInitialCooldown() {
            return 200;
        }

        @Override
        public int getSpellTicks() {
            return 20;
        }

        @Override
        public int startTimeDelay() {
            return 20;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity attacker = ShamanEntity.this.m_21188_();
            return super.m_8036_() && attacker != null && attacker.m_21205_().m_41720_() instanceof ProjectileWeaponItem && ShamanEntity.this.m_20280_((Entity)attacker) > 12.0 && ShamanEntity.this.m_9236_().m_46471_();
        }

        @Override
        public void castSpell() {
            LivingEntity attacker = ShamanEntity.this.m_21188_();
            if (attacker != null) {
                ServerLevel serverWorld = (ServerLevel)attacker.m_9236_();
                double posX = attacker.m_20185_() + (double)ShamanEntity.this.m_9236_().m_213780_().m_188503_(3);
                double posY = attacker.m_20186_();
                double posZ = attacker.m_20189_() + (double)ShamanEntity.this.m_9236_().m_213780_().m_188503_(3);
                BlockPos pos = BlockPos.m_274561_((double)posX, (double)posY, (double)posZ);
                LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(attacker.m_9236_());
                lightningEntity.m_20035_(pos, 0.0f, 0.0f);
                serverWorld.m_7967_((Entity)lightningEntity);
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.THUNDERBOLT;
        }
    }

    private class EffectSpellGoal
    extends SpellCastingEntity.CastSpellGoal {
        private EffectSpellGoal() {
            super(ShamanEntity.this);
        }

        @Override
        protected int getInitialCooldown() {
            return 200;
        }

        @Override
        public int getSpellTicks() {
            return 60;
        }

        @Override
        public int startTimeDelay() {
            return 10;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_();
        }

        @Override
        public void castSpell() {
            LivingEntity livingEntity = ShamanEntity.this.m_5448_();
            if (livingEntity != null) {
                MobEffect statusEffect = ShamanEntity.this.f_19796_.m_188501_() <= 0.5f ? MobEffects.f_19613_ : MobEffects.f_19614_;
                livingEntity.m_7292_(new MobEffectInstance(statusEffect, 120 + ShamanEntity.this.f_19796_.m_188503_(80), 1, false, false, true));
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.WITHERING;
        }
    }
}

